#include <stdio.h>
#include <stdlib.h>
typedef struct {
    int xi;
    int vi;
} Racer;
double findKthPass(int N, int K, Racer* racers) {
    double low = 0, high = 1e9;
    while (high - low > 1e-7) {
        double mid = (low + high) / 2;
        int cnt = 0;
        for (int i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                double t = (double)(racers[j].xi - racers[i].xi) / (racers[i].vi - racers[j].vi);
                if (t >= 0 && t <= mid) {
                    cnt++;
                    if (cnt >= K) break;
                }
            }
            if (cnt >= K) break;
        }
        if (cnt >= K) high = mid;
        else low = mid;
    }
    return low;
}
int main() {
    int N, K;
    scanf("%d %d", &N, &K);
    Racer* racers = (Racer*)malloc(N * sizeof(Racer));
    for (int i = 0; i < N; ++i) {
        scanf("%d %d", &racers[i].xi, &racers[i].vi);
    }
    double result = findKthPass(N, K, racers);
    printf("%lf\n", result);
    free(racers);
    return 0;
}